class OneOnOne_Stats extends Mutator config(AltUT_OneOnOneDB);

var bool bSaved;

struct Data
{
var string 	Name;
var int 	Score;
var int		Deaths;
var int		Suicides;
var int		Headshots;
var int		Wins;
var int		Losses;
var int		Time;
var int		FirstBlood;
var int		KillingSpree;
var int		Rampage;
var int		Dominating;
var int		Unstopable;
var int		godlike;
var int		InactiveDays;
};

struct Scores
{
var string 	Name;
var int 	Score;
};

var config int DaysBeforeDeleted;
var config Data Player[5000];
var config int Day;
var config int NumRanked;

var bool bFirstBlood;

var int zzR, zzNumPlayers, zzNumRanked;

var scores Spree[8];

function xxCheckDay()
{
local int zzi;

	if ( Level.Day != Day )
		{
		for (zzi=0;zzi<5000;zzi++)
			{
			if ( Player[zzi].Name != "" )
				{
				Player[zzi].InactiveDays++;
				if ( Player[zzi].InactiveDays >= DaysBeforeDeleted )
					{
					Player[zzi].Name = "";
					Player[zzi].Score = 0;
					Player[zzi].Deaths = 0;
					Player[zzi].Suicides = 0;
					Player[zzi].Headshots = 0;
					Player[zzi].Wins = 0;
					Player[zzi].Losses = 0;
					Player[zzi].Time = 0;
					Player[zzi].FirstBlood = 0;
					Player[zzi].InactiveDays = 0;
					Player[zzi].KillingSpree = 0;
					Player[zzi].Rampage = 0;
					Player[zzi].Dominating = 0;
					Player[zzi].Unstopable = 0;
					Player[zzi].godlike = 0;
					}
				}
			}
		}
	Day = Level.Day;
}

function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	xxUpdateRanks();	
}

function xxUpdateRanks()
{
local Data zzTemp;
local int i;

	for (i=0;i<10;i++)
		{
		if ( Player[zzR+1].Score > Player[zzR].Score && Player[zzR+1].Name != "" )
			{
			zzTemp = Player[zzR];
			Player[zzR] = Player[zzR+1];
			Player[zzR+1] = zzTemp;
			}
		if ( Player[zzR].Name != "" )
			zzNumPlayers++;
		zzR++;
		if ( zzR >= 4999 )
			{
			zzR = 0;
			NumRanked = zzNumPlayers;
			zzNumPlayers = 0;
			}
		}
}

function xxUpdateDB()
{
Local Pawn P;
local int i,zzS1,zzS2,Num;
local bool bFound;
local string zzWinner,zzP1,zzP2;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( Num == 0 )
			{
			zzS1 = P.PlayerReplicationInfo.Score;
			zzP1 = P.PlayerReplicationInfo.PlayerName;
			Num++;
			}
		else
			{
			zzS2 = P.PlayerReplicationInfo.Score;
			zzP2 = P.PlayerReplicationInfo.PlayerName;
			}
		myPRI(P.PlayerReplicationInfo).NumRanked = NumRanked;
		}
	if ( zzS1 > zzS2 )
		zzWinner = zzP1;
	else
		zzWinner = zzP2;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		for (i=0;i<5000;i++)
			{
			if ( Player[i].Name == P.PlayerReplicationInfo.PlayerName )
				{
				bFound = True;
				Player[i].Score += P.PlayerReplicationInfo.Score;
				Player[i].Deaths += P.PlayerReplicationInfo.Deaths;
				Player[i].Headshots = myPRI(P.PlayerReplicationInfo).Headshots;
				if ( P.PlayerReplicationInfo.PlayerName == zzWinner )
					{
					Player[i].Wins++;
					myPRI(P.PlayerReplicationInfo).Wins++;
					}
				else
					{
					Player[i].Losses++;
					myPRI(P.PlayerReplicationInfo).Losses++;
					}
				Player[i].Time = myPRI(P.PlayerReplicationInfo).TotalTime;
				Player[i].InactiveDays = 0;
				Player[i].Suicides = myPRI(P.PlayerReplicationInfo).Suicides;
				Player[i].FirstBlood = myPRI(P.PlayerReplicationInfo).FirstBlood;
				Player[i].KillingSpree = myPRI(P.PlayerReplicationInfo).KillingSpree;
				Player[i].Rampage = myPRI(P.PlayerReplicationInfo).Rampage;
				Player[i].Dominating = myPRI(P.PlayerReplicationInfo).Dominating;
				Player[i].Unstopable = myPRI(P.PlayerReplicationInfo).Unstopable;
				Player[i].godlike = myPRI(P.PlayerReplicationInfo).godlike;
				myPRI(P.PlayerReplicationInfo).AllTimeScore = Player[i].Score;
				myPRI(P.PlayerReplicationInfo).AllTimeDeaths = Player[i].deaths;
				i = 50000;
				}
			}
		if ( !bFound )
			{
			for (i=0;i<5000;i++)
				{
				if ( Player[i].Name == "" )
					{
					Player[i].Name = P.PlayerReplicationInfo.PlayerName;
					Player[i].Score += P.PlayerReplicationInfo.Score;
					Player[i].Deaths += P.PlayerReplicationInfo.Deaths;
					Player[i].Headshots = myPRI(P.PlayerReplicationInfo).Headshots;
					if ( P.PlayerReplicationInfo.PlayerName == zzWinner )
						{
						Player[i].Wins++;
						myPRI(P.PlayerReplicationInfo).Wins++;
						}
					else
						{
						Player[i].Losses++;
						myPRI(P.PlayerReplicationInfo).Losses++;
						}
					Player[i].Time = myPRI(P.PlayerReplicationInfo).TotalTime;
					Player[i].InactiveDays = 0;
					Player[i].Suicides = myPRI(P.PlayerReplicationInfo).Suicides;
					Player[i].FirstBlood = myPRI(P.PlayerReplicationInfo).FirstBlood;
					Player[i].KillingSpree = myPRI(P.PlayerReplicationInfo).KillingSpree;
					Player[i].Rampage = myPRI(P.PlayerReplicationInfo).Rampage;
					Player[i].Dominating = myPRI(P.PlayerReplicationInfo).Dominating;
					Player[i].Unstopable = myPRI(P.PlayerReplicationInfo).Unstopable;
					Player[i].godlike = myPRI(P.PlayerReplicationInfo).godlike;
					myPRI(P.PlayerReplicationInfo).AllTimeScore = Player[i].Score;
					myPRI(P.PlayerReplicationInfo).AllTimeDeaths = Player[i].deaths;
					i = 50000;
					}
				}
			}
		}
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local int i;

	if ( Killer != None )
		{
		for (i=0;i<8;i++)
			{
			if ( Spree[i].Name == Killer.PlayerReplicationInfo.PlayerName || Spree[i].Name == "" )
				{
				Spree[i].Name = Killer.PlayerReplicationInfo.PlayerName;
				Spree[i].Score++;
				if ( Spree[i].Score == 5 )
					myPRI(Killer.PlayerReplicationInfo).KillingSpree++;
				else if ( Spree[i].Score == 10 )
					myPRI(Killer.PlayerReplicationInfo).Rampage++;
				else if ( Spree[i].Score == 15 )
					myPRI(Killer.PlayerReplicationInfo).Dominating++;
				else if ( Spree[i].Score == 20 )
					myPRI(Killer.PlayerReplicationInfo).Unstopable++;
				else if ( Spree[i].Score == 25 )
					myPRI(Killer.PlayerReplicationInfo).godlike++;
				i = 50;
				}
			}
		}

	if ( Killed != None )
		{
		for (i=0;i<8;i++)
			{
			if ( Spree[i].Name == Killed.PlayerReplicationInfo.PlayerName || Spree[i].Name == "" )
				{
				Spree[i].Name = Killed.PlayerReplicationInfo.PlayerName;
				Spree[i].Score = 0;
				i = 50;
				}
			}
		}

	if ( damageType == 'Decapitated' && Killer != Killed )
		{
		myPRI(Killer.PlayerReplicationInfo).Headshots++;
		}

	if ( Killer == Killed || Killer == None)
		{
		myPRI(Killed.PlayerReplicationInfo).Suicides++;
		}

	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		}
}

function PreBeginPlay()
{
	Super.PreBeginPlay();

	xxCheckDay();

	SetTimer(1.0,True);
}

function Timer()
{
Local Pawn P;
local int i;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( !myPRI(P.PlayerReplicationInfo).bUpdated )
			{
			for (i=0;i<5000;i++)
				if ( Player[i].Name == P.PlayerReplicationInfo.PlayerName )
					{
					//assign variables from database to players myPRI
					myPRI(P.PlayerReplicationInfo).AllTimeScore = Player[i].Score;
					myPRI(P.PlayerReplicationInfo).AllTimeDeaths = Player[i].deaths;
					myPRI(P.PlayerReplicationInfo).Suicides = Player[i].Suicides;
					myPRI(P.PlayerReplicationInfo).Headshots = Player[i].Headshots; 
					myPRI(P.PlayerReplicationInfo).Wins = Player[i].Wins;
					myPRI(P.PlayerReplicationInfo).Losses = Player[i].Losses;
					myPRI(P.PlayerReplicationInfo).TotalTime = Player[i].Time;
					myPRI(P.PlayerReplicationInfo).FirstBlood = Player[i].FirstBlood;
					myPRI(P.PlayerReplicationInfo).Rank = i+1;
					myPRI(P.PlayerReplicationInfo).NumRanked = NumRanked;
					myPRI(P.PlayerReplicationInfo).KillingSpree = Player[i].KillingSpree;
					myPRI(P.PlayerReplicationInfo).Rampage = Player[i].Rampage;
					myPRI(P.PlayerReplicationInfo).Dominating = Player[i].Dominating;
					myPRI(P.PlayerReplicationInfo).Unstopable = Player[i].Unstopable;
					myPRI(P.PlayerReplicationInfo).godlike = Player[i].godlike;
					i=50000;
					}
			myPRI(P.PlayerReplicationInfo).bUpdated = True;	
			}
		}

	if (NextMutator != None)
		NextMutator.ModifyPlayer(P);
}

function ScoreKill(pawn Killer, pawn Other)
{
	Super.ScoreKill(Killer, Other);

	if ( Killer != Other && Killer != None && !bFirstBlood )
		{
		myPRI(Killer.PlayerReplicationInfo).FirstBlood++;
		bFirstBlood = True;
		}

	if ( Killer == Other || killer == None )
		{
		if ( Other.IsA('PlayerPawn') )
			myPRI(Other.PlayerReplicationInfo).Suicides++;
		}

	if ( NextMutator != None )
		{
		NextMutator.ScoreKill(Killer, Other);
		}
}

function bool HandleEndGame()
{
	Super.HandleEndGame();

	if (!bSaved)
		{
		xxUpdateDB();
		bSaved = True;
		SaveConfig();
		}

	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

defaultproperties:
{
DaysBeforeDeleted=30
bSaved=False
}









